% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createDataframe.R
\name{createDataframe}
\alias{createDataframe}
\title{Dataframe creation}
\usage{
createDataframe(projectName, clearHalo, diskDiam = 6, maxDist = 30,
  standardLoc = 2.5, removeClear = FALSE, nameVector = TRUE,
  typeVector = TRUE, typePlace = 2, typeName = "type")
}
\arguments{
\item{projectName}{the short name in use for the project.}

\item{clearHalo}{numeric value that indicates which picture should be used to represent a clear halo (i.e., the clear space beside the disk).}

\item{diskDiam}{the diameter of the diffusion disk in mm, defaults to 6.}

\item{maxDist}{a numeric value indicating the maximum distance away from the disk to be considered. Defaults to 30mm.}

\item{standardLoc}{a numberic value indicating the location (on the disk) to use to standardize intensity across photographs. The position of standardLoc is a position that should theoretically have the same intensity in all photographs, i.e., the white of the disk. The defaul value (2.5mm) was chosen after testing of 6mm disks that contain some writing. If smaller disks are used standardLoc should be scaled appropriately. You can see where standardLoc falls in each photograph in \code{plotRaw} (the red dashed line). To suppress this standardization use standardLoc = FALSE.}

\item{removeClear}{a logical value that indicates whether to remove the clear halo picture from the dataset (i.e., is this picture an experimental picture, or one solely included to use as a clear halo). Defaults to FALSE.}

\item{nameVector}{either a logial value or a character vector. Supported values are \code{nameVector} = "TRUE" to assign the photograph name to the 'name' column, \code{nameVector} = "FALSE" to assign th photograph number to the 'name' column, or \code{nameVector} = a vector the same length as the number of photographs indicating the desired names.}

\item{typeVector}{a logical value. \code{typeVector} = "TRUE" will add a 'type' vector to the dataframe using values found in the \code{typePlace} position of the photograph names (see \code{\link{IJMacro}} for more details) while \code{typeVector} = "FALSE" will not add a type column.}

\item{typePlace}{a number that indicates the position of the photograph name to be stored as the 'type' vector'. Defaults to 2. For more details see \code{\link{IJMacro}}}

\item{typeName}{a character string that indicates what to name the typeVector. Defaults to "type".}
}
\value{
A dataframe "projectName.df" is saved to the global environment and a .csv file "projectName_df.csv" is exported to the "parameter_files" directory.
}
\description{
\code{createDataframe} saves the calculated resistance, perseverence and sensitivity estimates
}
\details{
A dataframe with 11 columns:
\itemize{
		\item\bold{name:} determined by \code{nameVector}, either photograph names, photograph numbers, or a user-supplied list of names
	 	\item\bold{line:} the first components of the \code{namesVector}; everything that comes before the first "_" in the photograph name
		\item\bold{type:} the location within the \code{name} of the phograph type is supplied by \code{typePlace}. Use \code{\link{addType}} if more than one type column are desired.
		\item\bold{RAD80, RAD50, RAD20:} resistance parameters, coresponding to the distance in mm of 80\%, 50\% and 20\% reduction in growth
		\item\bold{FoG80, FoG50, FoG20:} perseverence parameters, coresponding to the fraction of growth achieved above the 80\%, 50\% and 20\% reduction in growth points
		\item\bold{slope:} sensitivity parameter, indicating the slope at the midpoint, i.e., how rapidly the population changes from low growth to full growth
	}
}
\examples{
\dontrun{
createDataframe("myProject", clearHalo=1)
createDataframe("myProject", clearHalo=1, removeClear = TRUE, typeName = "drugAmt")
}
}

