% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.r
\name{compute.disk.frame}
\alias{compute.disk.frame}
\title{Compute without writing}
\usage{
\method{compute}{disk.frame}(x, name, outdir = tempfile("tmp_df_",
  fileext = ".df"), overwrite = TRUE, ...)
}
\arguments{
\item{x}{a disk.frame}

\item{name}{Not used. Kept for compatibility with dplyr}

\item{outdir}{the output directory}

\item{overwrite}{whether to overwrite or not}

\item{...}{Not used. Kept for dplyr compatibility}
}
\description{
Perform the computation; same as calling map without .f and lazy = FALSE
}
\examples{
cars.df = as.disk.frame(cars)
cars.df2 = cars.df \%>\% map(~.x)
# the computation is performed and the data is now stored elsewhere
cars.df3 = compute(cars.df2)

# clean up
delete(cars.df)
delete(cars.df3)
}
