% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_afcm_utils.R
\name{e_afcmcat}
\alias{e_afcmcat}
\title{AFCM plot of categories}
\usage{
e_afcmcat(
  modelo,
  axes = c(1, 2),
  colorCat = "forestgreen",
  cos2 = 0,
  colorCos = "darkorchid",
  titulos = c("Bien Representados", "Mal Representados")
)
}
\arguments{
\item{modelo}{an object of class AFCM [FactoMineR].}

\item{axes}{a numeric vector of length 2 specifying the dimensions to be plotted.}

\item{colorCat}{a color for the categories well represented.}

\item{cos2}{a numeric value from 0 to 1 specifying the quality of the categories.}

\item{colorCos}{a color for the categories badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}
}
\value{
echarts4r plot
}
\description{
AFCM plot of categories
}
\examples{
data("poison", package = "FactoMineR")
poison.active <- poison[1:55, 5:15]
p <- FactoMineR::MCA(poison.active, graph = FALSE)
e_afcmcat(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
