% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discourseGT-package.R
\docType{package}
\name{discourseGT-package}
\alias{discourseGT}
\alias{discourseGT-package}
\title{discourseGT: A package to analyze groups patterns using graph theory in educational settings}
\description{
The package utilizes the various network libraries to produce network analysis in educational settings.
This package allows researchers to visualize transcripts in a succinct format through the lens of graph theory.

Some features of the package are:
\itemize{
\item \code{tabulate_edges()} can calculate the weighted edge list from the input data and number of silent nodes not captured in the data.
\item \code{prepareGraphs()} can prepare the igraph object from the weighted edge list.
\item \code{coreNetAnalysis()} can analyze the input igraph object and returns basic network statistics.
\item \code{subgroupNetAnalysis()} can analyze the input igraph object for potential subgroups.
\item \code{summaryNet()} can summarize the analytical output from several other functions into a single output.
\item \code{basicPlot()} can plot a basic network graph utilizing the default R visualization backend.
\item \code{plot1Att()} can plot a network graph with a single input attribute.
\item \code{plot2Att()} can plot a network graph with two input attributes.
\item \code{plotNGTData()} can analyze non-graph theory statistics and visualizes them in three plots.
\item \code{writeData()} can write any data object files as an appropriate format to a specified user directory.
}

A detailed tutorial can be found at \url{https://github.com/q1cui/discourseGT/blob/cc592b48f9e0e70bf6ae82c91b6008b81b3f94e9/vignettes/discourseGT_new.pdf}
}
\author{
\strong{Maintainer}: Qi Cui \email{q1cui@ucsd.edu}

Authors:
\itemize{
  \item Albert Chai \email{albertchai@ucsd.edu}
  \item Andrew Lee \email{aleet383@ucla.edu}
  \item Joshua Le \email{jpl038@ucsd.edu}
  \item Jitarth Sheth \email{jhsheth@ucsd.edu}
  \item Stanley Lo \email{smlo@ucsd.edu}
}

Other contributors:
\itemize{
  \item Katherine Ly \email{ktl045@ucsd.edu} [contributor]
  \item Kevin Banh \email{kebanh@ucsd.edu} [contributor]
  \item Priya Pahal \email{ppahal@ucsd.edu} [contributor]
}

}
\keyword{internal}
