% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_discord_data.R
\name{discord_data}
\alias{discord_data}
\title{Restructure Data to Determine Kinship Differences}
\usage{
discord_data(
  data,
  outcome,
  predictors,
  id = "extended_id",
  sex = "sex",
  race = "race",
  pair_identifiers,
  demographics = "both"
)
}
\arguments{
\item{data}{A data frame.}

\item{outcome}{A character string containing the outcome variable of
interest.}

\item{predictors}{A character vector containing the column names for
predicting the outcome.}

\item{id}{A unique kinship pair identifier.}

\item{sex}{A character string for the sex column name.}

\item{race}{A character string for the race column name.}

\item{pair_identifiers}{A character vector of length two that contains the
variable identifier for each kinship p}

\item{demographics}{Indicator variable for if the data has the sex and race
demographics. If both are present (default, and recommended), value should
be "both". Other options include "sex", "race", or "none".}
}
\value{
A data frame that
}
\description{
Restructure Data to Determine Kinship Differences
}
\examples{

discord_data(data = sample_data,
outcome = "height",
predictors = "weight",
pair_identifiers = c("_s1", "_s2"),
sex = NULL,
race = NULL,
demographics = "none")

}
