% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfzinb.R
\name{dfzinb}
\alias{dfzinb}
\title{Discrete factor analysis with the zero inflated negative binomial distribution.}
\usage{
dfzinb(y, tol = 1e-06)
}
\arguments{
\item{y}{Data, an n by d numeric matrix}

\item{tol}{tolerance value for optimizations}
}
\value{
A list with entries
\item{AIC}{AIC value for the optimal model}
\item{indexmat}{Factors and variables in each factor}
\item{estpi0}{Estimated value of p for the zero inflated part in the negative binomial distributed factor}
\item{estr0}{Estimated value of r the negative binomial distributed factor(s)}
\item{estp0}{Estimated value of p the negative binomial distributed factor(s)}
\item{estpi}{Estimated parameters for the zero inflated part in the negative binomial distributed observations(s)}
\item{estr}{Estimated value of r negative binomial distributed observations(s)}
\item{estp}{Estimated value of p negative binomial distributed observations(s)}
}
\description{
Discrete factor analysis with the zero inflated negative binomial distribution.
}
\examples{
dfzinb(zinb100_Data[1:40,1:3])
}
