% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reView.R
\name{reView}
\alias{reView}
\title{A shiny app to reView and modify twoStepsBenchmarks}
\usage{
reView(object, hfserie_name = NULL, lfserie_name = NULL, compare = TRUE)
}
\arguments{
\item{object}{a twoStepsBenchmark with an univariate hfserie, a reViewOutput,
or a character of length 1 with the path of their RDS file. If a reViewOutput
is chosen, the former new benchmark is taken as the old one.}

\item{hfserie_name}{a character of length 1. The name of the hfserie.}

\item{lfserie_name}{a character of length 1. The name of the lfserie.}

\item{compare}{a boolean of length 1, that tells if the outputs of
the old benchmark should be displayed.}
}
\value{
a list, of class reViewOutput, containing the new benchmark,
the old one, the names of the series and the boolean compare.
This object can also be saved in RDS format through the app.
The reViewOutput object can be displayed as a html report with the same
informations than in shiny, with the \link{rePort} method.
}
\description{
reView allows the user to easily access diverse outputs in order to
review a benchmark object, made with \link{twoStepsBenchmark}.

The \code{hfserie_name} and \code{lfserie_name} define :
}
\details{
\itemize{
\item the default file name of the RDS file
\item the names of the series in the output \code{call} element
}

By default, these are set as defined in their \code{call} element.

The app is made of \pkg{shiny} modules in order to make it easy to integrate
it into a wider application. In the module part, every input are defined as
reactive variables.
}
\examples{
\dontrun{
reView(twoStepsBenchmark(turnover,construction))
}

}
\seealso{
\link{rePort}
}
