% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metropdir.adapt.R
\name{metropdir.adapt}
\alias{metropdir.adapt}
\title{Directional Metropolis Hastings with Adaptation.}
\usage{
metropdir.adapt(obj, dobj, initial, lchain, sd.prop = 1, steplen = 0,
  s = 0.95, batchlen = 100, targetacc = 0.234, ...)
}
\arguments{
\item{obj}{an R function that evaluates the log unnormalized probability
density of the desired equilibrium distribution of the Markov chain.
First argument is the state vector of the Markov chain.  Other arguments
arbitrary and taken from the \code{...} arguments of this function.
Should return \code{- Inf} for points of the state space having
probability zero under the desired equilibrium distribution.}

\item{dobj}{an R function that evaluates the derivative of the log unnormalized probability density at the current state of the markov chain.}

\item{initial}{Initial state of the markov chain. \code{obj(state)} must not return #' \code{-Inf}}

\item{lchain}{length of the chain}

\item{sd.prop}{scale to use for the proposal}

\item{steplen}{tuning parameter in mean of proposal}

\item{s}{tuning parameter in the covariance of proposal}

\item{batchlen}{length of batch used for update. Default is 100.}

\item{targetacc}{Target acceptance ratio}

\item{...}{any arguments to be passed to obj and dobj.}
}
\description{
Implements adaptive version of directional Metropolis Hastings.
}
\details{
This function is for automatically select a scaling factor for the directional Metropolis Hastings algorithm. This function uses batch wise update of the scale parameter to produce a adaptive chain. The user is required to supply a target acceptance ratio. The adaptive scheme modifies the scale parameter to achieve the target acceptance ratio. It is recommended that to check the output of the adaptation history as returned by the function.
}
\examples{
\dontrun{
Sigma <- matrix(c(1,0.2,0.2,1),2,2)
mu <- c(1,1)
Sig.Inv <- solve(Sigma)
Sig.det.sqrt <- sqrt(det(Sigma))
logf <- function(x,mu,Sig.Inv){
  x.center <- as.numeric((x-mu))
  out <- crossprod(x.center,Sig.Inv)
  out <- sum(out*x.center)
  -out/2
  }

gr.logf <- function(x,mu,Sig.Inv){
  x.center <- as.numeric((x-mu))
  out <- crossprod(x.center,Sig.Inv)
  -as.numeric(out)
}
set.seed(1234)
system.time(out <- metropdir.adapt(obj = logf, dobj = gr.logf, initial = c(1,1),
                         lchain = 1e4,sd.prop=1,steplen=0,s=1, mu = mu,
                         Sig.Inv = Sig.Inv,targetacc=0.44))
#acceptance rate
out$accept
#density plot
plot(density(out$batch[,1]))
}
}
\author{
Abhirup Mallik, \email{malli066@umn.edu}
}
\seealso{
\code{\link{metropdir}} for DMH, \code{\link{iact}} for integrated auto correlation times, \code{\link{mcmcdiag}}, \code{\link{msjd}} for mean squared jump distance.
for summary of diagnostic measures of a chain, \code{\link{multiESS}} for Multivariate effective sample size.
}
\keyword{adaptive}
\keyword{dmh,}
\keyword{mcmc,}

