% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directExplorer2d.R
\name{directExplorer2d}
\alias{directExplorer2d}
\title{Batch Direction Analysis in 2-dimentional space}
\usage{
directExplorer2d(Tc, annotation=NULL, gene.method="OSP", 
path.method="Stouffer", top=10, ...)
}
\arguments{
\item{Tc}{a numeric matrix with 2 columns. The rows are genes or phosphorylation sites and the columns 
are treatments vs control statistics.}

\item{annotation}{a list with names correspond to pathways or kinases and elements correspond to 
genes or substrates belong to each pathway or kinase, respectively.}

\item{gene.method}{the method to be used for integrating statistics across treatments for each gene
or phosphorylation site.  Available methods are Stouffer, OSP, Fisher, and maxP. 
Default method is OSP.}

\item{path.method}{the method to be used for integrating statistics of all genes or phosphorylation
sites that belongs to a pathway or kinase. Available methods are Stouffer, OSP, Fisher, and maxP. 
Default method is Stouffer.}

\item{top}{the number of entries to be highlighted in the plot.}

\item{...}{parameters for controlling the plot.}
}
\value{
The the list of enrichment analysis in tables.
}
\description{
Rotate to the direction of interest in polar coordinates by degree (e.g. pi/4).
}
\examples{
# load the phosphoproteomics dataset
data(HEK)

# load the kinase-substrate annoations
data(PhosphoSite)

# test enrichment on 8 directions in polar coordinate system.
bda <- directExplorer2d(Tc=HEK, annotation=PhosphoSite.mouse)

# the direction are denoted as follow for the two treatments vs control:
# ++: up-regulated in both treatments
# +*: up-regulated in the first treatment and unchanged in the second treatment
# +-: up-regulated in the first treatment and down-regulated in the second treatment
# *-: unchanged in the first treatment and down-regulated in the second treatment
# --: down-regulated in both treatments
# -*: down-regulated in the first treatment and unchanged in the second treatment
# -+: down-regulated in the first treatment and up-regulated in the second treatment
# *+: unchanged in the first treatment and up-regulated in the second treatment

# sort the most enriched phosphorylation sites and kinases on down-regulaiton from both 
# treatments (i.e. "--") and displa the top-10 entries
bda$gene.tab[order(bda$gene.tab[,"--"]),][1:10,]
bda$path.tab[order(bda$path.tab[,"--"]),][1:10,]

}

