% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcuts.R
\name{dipsaus-rstudio-shortcuts}
\alias{dipsaus-rstudio-shortcuts}
\alias{rs_add_insertion_shortcut}
\alias{rs_add_shortcut}
\alias{rs_remove_shortcut}
\title{Register customized R code to 'RStudio' shortcuts}
\usage{
rs_add_insertion_shortcut(which, txt, force = FALSE)

rs_add_shortcut(which, expr, force = FALSE, quoted = FALSE)

rs_remove_shortcut(which)
}
\arguments{
\item{which}{integer from 1 to 10, which keyboard shortcut to edit}

\item{txt}{an insertion/replacement shortcut to add}

\item{force}{whether to remove existing shortcut if the hot-key has been
registered}

\item{expr}{expression to run if shortcut is pressed}

\item{quoted}{whether \code{expr} is quoted, default is false}
}
\description{
'RStudio' keyboard shortcuts is handy, however, it is non-trivial
to set shortcuts that run customized code. The proposing functions
allow 10 customized R expressions to be registered. The first five
(1 to 5) are interactive shortcuts, the rest five
(6 to 10) are non-interactive.
}
\details{
There are two steps to register an 'RStudio' keyboard shortcut.

1. Please enable the shortcuts by opening
\code{'Tools' > 'Modify Keyboard Shortcuts'} in 'RStudio' menu bar;
search and locate add-in items starting with 'Dipsaus'; register hot-keys
of your choices, and then save. It is recommended that these
keys are \code{'Alt' + 1} to \code{'Alt' + 0}. On Apple, 'Alt' is
equivalent to 'option' key.

2. run \code{rs_add_insertion_shortcut} or \code{rs_add_shortcut} to
customize the behaviors of each shortcuts; see Examples.
}
\examples{

\dontrun{

# Need to run in RStudio
# Please read the Section 'Details' carefully

# --------------------------------------------

# I assume the shortcuts are Alt+1,2,...,9,0,
# corresponding to shortcuts 1 - 10

# Adds an insertion to Alt+9
rs_add_insertion_shortcut(9, " \%?<-\% ", force = TRUE)
# restart RStudio and try `Alt+9`


# Adds an expression to Alt+1
rs_add_shortcut(1, {
  expr <- sprintf("system.time({\n\%s\n})\n",
                  rstudioapi::selectionGet()$value)
  cat(expr)
  eval(parse(text = expr))
}, force = TRUE)

# Select any valid R code and press Alt+1


}

}
