% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lock.R
\name{lock}
\alias{lock}
\alias{dipsaus_lock}
\alias{dipsaus_unlock}
\title{Create or Unlock a Lock}
\usage{
dipsaus_lock(name, exclusive = TRUE, timeout = 10)

dipsaus_unlock(name, exclusive = TRUE, timeout = 10)
}
\arguments{
\item{name}{character, the locker's name, must be only letters and digits}

\item{exclusive}{logical whether the locker is exclusive. True for write
access, False for read access. Default is true.}

\item{timeout}{numeric, seconds to wait for the locker to lock or unlock}
}
\value{
Logical, whether the operation succeed.
}
\description{
A wrapper for 'synchronicity' package, but user can
interrupt the lock procedure anytime, and don't have to worry about
whether the lock exists or not.
}
\examples{
# unlock to prepare for the example
dipsaus_unlock('testlocker', timeout = 0.01)

# Create a locker, return TRUE
lock_success = dipsaus_lock('testlocker')
if(lock_success){
  cat2('testlocker has been locked')
}

# test whether locker has been locked
lock_success = dipsaus_lock('testlocker', timeout = 0.01)
if(!lock_success){
  cat2('attempt to lock testlocker failed')
}

# unlock
dipsaus_unlock('testlocker', timeout = 0.01)


}
