% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo-compat.R
\name{as_yearqtr}
\alias{as_yearqtr}
\alias{as_yearqtr.date_yq}
\alias{as_yearqtr.yearqtr}
\alias{as_yearmon}
\alias{as_yearmon.date_ym}
\alias{as_yearmon.yearmon}
\alias{as_yearweek}
\alias{as_yearweek.date_yw}
\alias{as_yearweek.yearweek}
\title{Coerce to zoo yearqtr objects}
\usage{
as_yearqtr(x)

\method{as_yearqtr}{date_yq}(x)

\method{as_yearqtr}{yearqtr}(x)

as_yearmon(x)

\method{as_yearmon}{date_ym}(x)

\method{as_yearmon}{yearmon}(x)

as_yearweek(x)

\method{as_yearweek}{date_yw}(x)

\method{as_yearweek}{yearweek}(x)
}
\arguments{
\item{x}{any \R object}
}
\value{
a \link[zoo:yearqtr]{zoo::yearqtr}, \link[zoo:yearmon]{zoo::yearmon} or \code{dint::yearweek} vector.
}
\description{
\code{as_yearqtr()} and \code{as_yearmon()} are included for interoperability with
\code{\link[zoo:yearqtr]{zoo::yearqtr()}}, an alternative year-quarter format that is based on a
decimal representation as opposed to dint's integer representation of
year-quarters. \code{as_yearweek()} follows a similar idea, but there is no
corresponding S3 class in \pkg{zoo}. These functions were included
for cases where you need a continuous representation of \code{date_xx} objects
other then \code{\link[base:Date]{base::Date()}} (for example, they are used by \link{scale_date_xx})
}
\examples{
q <- date_yq(2016, 1:4)
as.numeric(q)
qzoo <- as_yearqtr(q)
as.numeric(qzoo)

m <- date_ym(2016, 1:12)
as.numeric(m)
mzoo <- as_yearmon(m)
as.numeric(mzoo)

w <- date_yw(2016, 1:52)
as.numeric(w)
wzoo <- as_yearweek(w)
as.numeric(wzoo)

}
