% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_ym.R
\name{format_ym}
\alias{format_ym}
\title{Directly Create Formatted Year-Month Strings}
\usage{
format_ym(x, m = NULL, format = "iso")
}
\arguments{
\item{x, m}{Two integer (vectors). \code{m} is optional and the interpretation of
\code{x} will depend on whether \code{m} is supplied or not:
\itemize{
\item if only \code{x} is supplied, \code{x} will be passed to \code{\link[=as_date_ym]{as_date_ym()}}
(e.g. \code{x = 201604} means April 2016)
\item if \code{x} and \code{m} are supplied, \code{x} is interpreted as year and \code{m} as
month.
}}

\item{format}{A scalar character, valid values are: \code{"iso"}, \code{"short"}, and
\code{"shorter"}}
}
\value{
A character vector
}
\description{
Directly Create Formatted Year-Month Strings
}
\examples{

format_ym(2015, 5)
format_ym(201505, format = "short")
format_ym(201505, format = "shorter")

}
\seealso{
\code{\link[=format.date_ym]{format.date_ym()}}

Other ym convenience functions: \code{\link{first_day_ym}},
  \code{\link{first_day_y}}
}
\concept{ym convenience functions}
