% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R
\docType{methods}
\name{embed}
\alias{embed}
\alias{embed,ANY-method}
\alias{embed,dimRedData-method}
\alias{embed,formula-method}
\title{dispatches the different methods for dimensionality reduction}
\usage{
embed(.data, ...)

\S4method{embed}{formula}(.formula, .data, .method = dimRedMethodList(),
  .mute = character(0), .keep.org.data = TRUE, ...)

\S4method{embed}{ANY}(.data, .method = dimRedMethodList(),
  .mute = character(0), .keep.org.data = TRUE, ...)

\S4method{embed}{dimRedData}(.data, .method = dimRedMethodList(),
  .mute = character(0), .keep.org.data = TRUE, ...)
}
\arguments{
\item{.data}{object of class \code{dimRedData}}

\item{...}{the pameters, internally passed as a list to the
dimensionality reduction method as \code{pars = list(...)}}

\item{.formula}{a formula, see \code{\link{as.dimRedData}}.}

\item{.method}{character vector naming one of the dimensionality
reduction techniques.}

\item{.mute}{a character vector containing the elements you want to
mute (\code{c("message", "output")}), defaults to
\code{character(0)}.}

\item{.keep.org.data}{TRUE/FALSE keep the original data.}
}
\value{
an object of class \code{dimRedResult}
}
\description{
wraps around all dimensionality reduction functions.
}
\details{
Method must be one of \code{dimRedMethodList()}, partial matching
is performed. All parameters start with a dot, to avoid clashes
with partial argument matching (see the R manual section 4.3.2), if
there should ever occur any clashes in the arguments, call the
function with all arguments named, e.g. \code{embed(.data = dat,
.method = "mymethod", .d = "some parameter")}.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: embed a data.frame using a formula.

\item \code{ANY}: Embed anything as long as it can be coerced to
\code{dimRedData}.

\item \code{dimRedData}: Embed a dimRedData object
}}
\examples{
\dontrun{
embed_methods <- dimRedMethodList()
quality_methods <- dimRedQualityList()
dataset <- loadDataSet("Iris")

quality_results <- matrix(NA, length(embed_methods), length(quality_methods),
                              dimnames = list(embed_methods, quality_methods))
embedded_data <- list()

for (e in embed_methods) {
  message("embedding: ", e)
  embedded_data[[e]] <- embed(dataset, e, .mute = c("message", "output"))
  for (q in quality_methods) {
    message("  quality: ", q)
    quality_results[e, q] <- tryCatch(
      quality(embedded_data[[e]], q),
      error = function(e) NA
    )
  }
}

print(quality_results)
}
## embed a data.frame using a formula:
head(as.data.frame(
  embed(Species ~ Sepal.Length + Sepal.Width + Petal.Length + Petal.Width,
        iris, "PCA")
))

head(as.data.frame(
  embed(iris[, 1:4], "PCA")
))
head(as.data.frame(
  embed(as.matrix(iris[, 1:4]), "PCA")
))
}

