% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_dgm.R
\name{resample_dgm}
\alias{resample_dgm}
\title{Change the sampling of a digiRhythm friendly dataset}
\usage{
resample_dgm(data, new_sampling)
}
\arguments{
\item{data}{The dataframe containing the activity data}

\item{new_sampling}{The new sampling (multiple of current sampling) in
minutes}
}
\value{
A digiRhythm friendly dataset with the new sampling
}
\description{
This function upsamples the data but does not downsample them. The new
sampling should be a multiple of the current sampling period, and should be
given in minutes.
}
\examples{
data("df516b_2", package = "digiRhythm")
df <- df516b_2
df <- remove_activity_outliers(df)
new_sampling <- 30
new_dgm <- resample_dgm(df, new_sampling)
}
