% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startNLR.R
\name{startNLR}
\alias{startNLR}
\title{Calculates starting values for Non-Linear Regression DIF models.}
\usage{
startNLR(Data, group, model, match = "zscore", parameterization = "alternative",
simplify = F)
}
\arguments{
\item{Data}{numeric: a matrix or data.frame of binary data.}

\item{group}{numeric: binary vector of group membership.
"0" for reference group, "1" for focal group.}

\item{model}{character: generalized logistic regression model
to be fitted. See \strong{Details}.}

\item{match}{vector of matching criterion. Its length need to be the same as number
of observations in \code{Data}.}

\item{parameterization}{character: parameterization of regression
coefficients. Possible options are \code{"classic"} (IRT parameterization),
\code{"alternative"} (default) and \code{"logistic"} (logistic regression).
See \strong{Details}.}

\item{simplify}{logical: whether initial values should be simplified into the table.
This is only applicable when parameterization is the same for all items.}
}
\value{
A list containing elements representing items. Each element is a named numeric vector of length 8
with initial values for \code{difNLR} model.
}
\description{
Calculates starting values for \code{difNLR} function based
on linear approximation.
}
\details{
The \code{model} argument offers several predefined models. The options are as follows:
\code{Rasch} for 1PL model with discrimination parameter fixed on value 1 for both groups,
\code{1PL} for 1PL model with discrimination parameter fixed for both groups,
\code{2PL} for logistic regression model,
\code{3PLcg} for 3PL model with fixed guessing for both groups,
\code{3PLdg} for 3PL model with fixed inattention for both groups,
\code{3PLc} (alternatively also \code{3PL}) for 3PL regression model with guessing parameter,
\code{3PLd} for 3PL model with inattention parameter,
\code{4PLcgdg} for 4PL model with fixed guessing and inattention parameter for both groups,
\code{4PLcgd} (alternatively also \code{4PLd}) for 4PL model with fixed guessing for both groups,
\code{4PLcdg} (alternatively also \code{4PLc}) for 4PL model with fixed inattention for both groups,
or \code{4PL} for 4PL model.

Three possible parameterization can be specified in \code{"parameterization"} argument: \code{"classic"}
returns IRT parameters of reference group and differences in these parameters between reference and focal group.
\code{"alternative"} returns IRT parameters of reference group, the differences in parameters a and b between
two groups and parameters c and d for focal group. \code{"logistic"} returns parameters in logistic regression
parameterization.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMAT)

Data  <- GMAT[, 1:20]
group <- GMAT[, "group"]

# starting values for 3PL model
startNLR(Data, group, model = "3PL")

# starting values for 3PL model
# simplified into single table
startNLR(Data, group, model = "3PL", simplify = T)

# starting values for 3PL model
# with score as matching criterion
startNLR(Data, group, model = "3PL", match = "score")

# starting values for model specified for each item
startNLR(Data, group,
         model = c(rep("1PL", 5), rep("2PL", 5),
                   rep("3PL", 5), rep("4PL", 5)))

}
}
\references{
Drabinova, A. & Martinkova P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement, 54(4), 498-517.
}
\seealso{
\code{\link[difNLR]{difNLR}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
