% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfMLR.R
\name{ddfMLR}
\alias{ddfMLR}
\alias{plot.ddfMLR}
\alias{plot.ddfMR}
\alias{print.ddfMLR}
\title{Performs DDF detection using Multinomial Log-linear Regression model.}
\usage{
ddfMLR(Data, group, focal.name, key, type = "both",
alpha = 0.05, p.adjust.method = "none")

\method{print}{ddfMLR}(x, ...)

\method{plot}{ddfMLR}(x, item = "all", title, ...)
}
\arguments{
\item{Data}{character: either the unscored data matrix only, or the unscored data
matrix plus the vector of group. See \strong{Details}.}

\item{group}{numeric or character: either the binary vector of group membership or
the column indicator of group membership. See \strong{Details}.}

\item{focal.name}{numeric or character: indicates the level of \code{group} which corresponds to
focal group}

\item{key}{character: the answer key. See \strong{Details}.}

\item{type}{character: type of DDF to be tested (either "both" (default), "udif", or "nudif").
See \strong{Details}.}

\item{alpha}{numeric: significance level (default is 0.05).}

\item{p.adjust.method}{character: method for multiple comparison correction.
See \strong{Details}.}

\item{x}{an object of 'ddfMLR' class}

\item{...}{other generic parameters for \code{print} or \code{plot} functions.}

\item{item}{either character ("all"), or numeric vector, or single number
corresponding to column indicators. See \strong{Details}.}

\item{title}{string: title of plot.}
}
\value{
A list of class 'ddfMLR' with the following arguments:
\describe{
  \item{\code{Sval}}{the values of likelihood ratio test statistics.}
  \item{\code{mlrPAR}}{the estimates of final model.}
  \item{\code{mlrSE}}{standard errors of the estimates of final model.}
  \item{\code{parM0}}{the estimates of null model.}
  \item{\code{parM1}}{the estimates of alternative model.}
  \item{\code{alpha}}{numeric: significance level.}
  \item{\code{DDFitems}}{either the column indicators of the items which were detected as DDF, or \code{"No DDF item detected"}.}
  \item{\code{type}}{character: type of DIF that was tested.}
  \item{\code{p.adjust.method}}{character: method for multiple comparison correction which was applied.}
  \item{\code{pval}}{the p-values by likelihood ratio test.}
  \item{\code{adj.pval}}{the adjusted p-values by likelihood ratio test using \code{p.adjust.method}.}
  \item{\code{df}}{the degress of freedom of likelihood ratio test.}
  \item{\code{group}}{the vector of group membership.}
  \item{\code{Data}}{the data matrix.}
  }
}
\description{
Performs DDF detection procedure based on Multinomial Log-linear Regression model and
likelihood ratio test of submodel.
}
\details{
DDF detection procedure based on Multinomial Log-linear model.

The \code{Data} is a matrix whose rows represents examinee unscored answers and
columns correspond to the items. The \code{group} must be either a vector of the same
length as \code{nrow(data)} or column indicator of \code{Data}. The \code{key} must be
a vector of correct answers corresponding to columns of \code{Data}.

The \code{type} corresponds to type of DDF to be tested. Possible values are \code{"both"}
to detect any DDF (uniform and/or non-uniform), \code{"udif"} to detect only uniform DDF or
\code{"nudif"} to detect only non-uniform DDF.

The \code{p.adjust.method} is a character for \code{p.adjust} function from the
\code{stats} package. Possible values are \code{"holm"}, \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.

The output of the ddfMLR is displayed by the \code{print.ddfMLR} function.

The characteristic curve for item specified in \code{item} option can be plotted. For default
option \code{"all"} of item, characteristic curves of all converged items are plotted.
The drawn curves represent best model.

Missing values are allowed but discarded for item estimation. They must be coded as \code{NA}
for both, \code{data} and \code{group} parameters.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMATtest, GMATkey)

Data  <- GMATtest[, colnames(GMATtest) != "group"]
group <- GMATtest[, "group"]
key <- GMATkey

# Testing both DDF effects
x <- ddfMLR(Data, group, focal.name = 1, key)

# Testing both DDF effects with Benjamini-Hochberg adjustment method
ddfMLR(Data, group, focal.name = 1, key, p.adjust.method = "BH")

# Testing uniform DDF effects
ddfMLR(Data, group, focal.name = 1, key, type = "udif")
# Testing non-uniform DDF effects
ddfMLR(Data, group, focal.name = 1, key, type = "nudif")

# Graphical devices
plot(x, item = 1)
plot(x, item = x$DDFitems)
plot(x, item = "all")
}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
}
\seealso{
\code{\link[stats]{p.adjust}}
}
\keyword{DDF}

