% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startNLR.R
\name{startNLR}
\alias{startNLR}
\title{Calculates starting values for \code{difNLR} function.}
\usage{
startNLR(data, group, parameterization = "IRT")
}
\arguments{
\item{data}{numeric: a matrix or data.frame of binary data.}

\item{group}{numeric: binary vector of group membership. "0" for reference group, "1" for focal group.}

\item{parameterization}{character: parameterization of regression coefficients. Possible options are \code{"IRT"} (Item response theory, default option) and \code{"LR"} (Logistic regression)}
}
\value{
A data.frame containing rows representing items and 5 columns representing parameters of \code{difNLR} model. First column represents discrimination (a), second difficulty (b), third guessing (c), fourth difference in discrimination between reference and focal group (aDif) and fifth difference in difficulty between reference and focal group (bDif).
}
\description{
Calculates starting values for \code{difNLR} function based on linear approximation.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMAT)

data  <- GMAT[, colnames(GMAT) != "group"]
group <- GMAT[, "group"]

# starting values
startNLR(data, group)
}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
\references{
Drabinova, A. and Martinkova P. (2016). Detection of Differenctial Item Functioning Based on Non-Linear Regression, Technical Report, V-1229, \url{http://hdl.handle.net/11104/0259498}.
}

