% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genNLR.R
\name{genNLR}
\alias{genNLR}
\title{Generates binary data set based on \code{difNLR} model.}
\usage{
genNLR(N = 1000, ratio = 1, parameters)
}
\arguments{
\item{N}{numeric: number of rows representing correspondents.}

\item{ratio}{numeric: ratio of number of rows for reference and focal group.}

\item{parameters}{numeric: matrix representing true parameters of \code{difNLR} model. See \strong{Details}.}
}
\value{
A data.frame containing \code{N} rows representing correspondents and n+1 columns representing n items. Last column is group membership variable with coding 0 for reference group and 1 for focal group.
}
\description{
Generates binary data set based on \code{difNLR} model with the same guessing parameter for both groups, reference and focal.
}
\details{
The \code{parameters} is a numeric matrix with 5 columns. First column represents discrimination parameter (a), second represents difficulty (b), third guessing (c), fourth difference in discrimination between reference and focal group (aDif) and fifth difference in difficulty between reference and focal group (bDif). Rows represent items and their number (n) corresponds to number of columns of resultant data set.
}
\examples{
\dontrun{
# seed
set.seed(123)
# generating parameters without DIF, 10 items
parameters <- data.frame(a = runif(10, 0.8, 2),
                         b = rnorm(10),
                         c = runif(10, 0, 0.4),
                         aDif = 0, bDif = 0)

# generating data set with 300 observations (150 each group)
genNLR(N = 300, parameters = parameters)

# generating data set with 300 observations (250 reference group, 50 focal)
genNLR(N = 300, ratio = 5, parameters = parameters)

}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
\references{
Drabinova, A. and Martinkova P. (2016). Detection of Differenctial Item Functioning Based on Non-Linear Regression, Technical Report, V-1229, \url{http://hdl.handle.net/11104/0259498}.
}

