% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullnessIndex.R
\name{GastrosomaticIndex}
\alias{GastrosomaticIndex}
\title{Calculates Gastro-somatic Index (AKA Fullness Index, Index of fullness)}
\usage{
GastrosomaticIndex(StomachData, Calc.Vacuity = FALSE)
}
\arguments{
\item{StomachData}{Object of class data frame containing stomach data. The data frame must be set
up as follows. The first column should contain the specimen identifier, the second column the 
stomach weight, and the third column the weight of the specimens.}

\item{Calc.Vacuity}{Logical. Should the vacuity index also be calculated? Default is FALSE.}
}
\value{
Object of Class List of length 2 or 3. If Calc.Vacuity = FALSE, a list of length two 
is returned containing a named vector of individual specimen gastro-somatic index as well as a
numeric vector length of 1 containing the mean gastro-somatic index. If Calc.Vacuity = TRUE, an
additional numeric vector of length 1 is returned containing the calculated vacuity index.
}
\description{
This function calculates Gastro-somatic fullness, the relationship between stomach
weight and body weight to assess fullness.
}
\examples{
data(SebastesStomachs)#load example data
#Calculate the Gastro-somatic Index
my.GSI <- GastrosomaticIndex (StomachData = SebastesStomachs)
#Calculate the Gastro-somatic Index and Vacuity Index
my.GSI <- GastrosomaticIndex (StomachData = SebastesStomachs, Calc.Vacuity = TRUE)
}
\references{
Hureau J-C. 1970. Biologie comparee de quelques poissons antarctiques (Nototheniidae). Bulletin de l'Institut Oceanographique de Monaco 68:1-244.
}
\seealso{
\code{\link{VacuityIndex}}
}
\author{
Samuel Borstein
}
