% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{reset.sim}
\alias{reset.sim}
\title{reset.sim}
\usage{
reset.sim(time.periods = 4, n = 5000, ipw = TRUE, reg = TRUE)
}
\arguments{
\item{time.periods}{The number of time periods to include}

\item{n}{The total number of observations}

\item{ipw}{If TRUE, sets parameters so that DGP is
compatible with recovering ATT(g,t)'s using IPW (i.e.,
where logit that just includes a linear term in X works).  If
FALSE, sets parameters that will be incompatible with IPW.
Either way, these parameters can be specified by the user
if so desired.}

\item{reg}{If TRUE, sets parameters so that DGP is compatible
with recovering ATT(g,t)'s using regressions on untreated
untreated potential outcomes.  If FALSE, sets parameters that
will be incompatible with using regressions (i.e., regressions
that include only linear term in X).  Either way, these
parameters can be specified by the user if so desired.}
}
\value{
list of simulation parameters
}
\description{
a function to create a "reasonable" set of parameters
to create simulated panel data that obeys a parallel trends assumption.
In particular, it provides parameters where the the effect of participating
in the treatment is equal to one in all post-treatment time periods.

After calling this function, the user can change particular values of the
parameters in order to generate dynamics, heterogeneous effects across
groups, etc.
}
