% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominoplot.R
\name{domino_plot}
\alias{domino_plot}
\title{Domino Plot Visualization}
\usage{
domino_plot(
  data,
  gene_list,
  switch_axis = FALSE,
  min_dot_size = 1,
  max_dot_size = 5,
  spacing_factor = 3,
  var_id = "var",
  feature_col = "gene",
  celltype_col = "Celltype",
  contrast_col = "Contrast",
  contrast_levels = c("Clinical", "Pathological"),
  contrast_labels = c("Clinical", "Pathological"),
  logfc_col = "avg_log2FC",
  pval_col = "p_val_adj",
  logfc_limits = c(-1.5, 1.5),
  logfc_colors = c(low = "blue", mid = "white", high = "red"),
  color_scale_name = "Log2 Fold Change",
  size_scale_name = "-log10(adj. p-value)",
  axis_text_size = 8,
  aspect_ratio = NULL,
  base_width = 5,
  base_height = 4,
  output_file = NULL
)
}
\arguments{
\item{data}{A data frame containing gene expression data.}

\item{gene_list}{A character vector of gene names to include in the plot.}

\item{switch_axis}{A logical value indicating whether to switch the x and y axes. Default is \code{FALSE}.}

\item{min_dot_size}{A numeric value indicating the minimum dot size in the plot. Default is \code{1}.}

\item{max_dot_size}{A numeric value indicating the maximum dot size in the plot. Default is \code{5}.}

\item{spacing_factor}{A numeric value indicating the spacing between gene pairs. Default is \code{3}.}

\item{var_id}{A string representing the column name in \code{data} for the variable identifier. Default is \code{"var"}.}

\item{feature_col}{A string representing the column name in \code{data} for the feature variable (e.g., genes). Default is \code{"gene"}.}

\item{celltype_col}{A string representing the column name in \code{data} for the cell type variable. Default is \code{"Celltype"}.}

\item{contrast_col}{A string representing the column name in \code{data} for the contrast variable. Default is \code{"Contrast"}.}

\item{contrast_levels}{A character vector specifying the levels of the contrast variable. Default is \code{c("Clinical", "Pathological")}.}

\item{contrast_labels}{A character vector specifying the labels for the contrasts in the plot. Default is \code{c("Clinical", "Pathological")}.}

\item{logfc_col}{A string representing the column name in \code{data} for the log fold change values. Default is \code{"avg_log2FC"}.}

\item{pval_col}{A string representing the column name in \code{data} for the adjusted p-values. Default is \code{"p_val_adj"}.}

\item{logfc_limits}{A numeric vector of length 2 specifying the limits for the log fold change color scale. Default is \code{c(-1.5, 1.5)}.}

\item{logfc_colors}{A named vector specifying the colors for the low, mid, and high values in the color scale. Default is \code{c(low = "blue", mid = "white", high = "red")}.}

\item{color_scale_name}{A string specifying the name of the color scale in the legend. Default is \code{"Log2 Fold Change"}.}

\item{size_scale_name}{A string specifying the name of the size scale in the legend. Default is \code{"-log10(adj. p-value)"}.}

\item{axis_text_size}{A numeric value specifying the size of the axis text. Default is \code{8}.}

\item{aspect_ratio}{A numeric value specifying the aspect ratio of the plot. If \code{NULL}, it's calculated automatically. Default is \code{NULL}.}

\item{base_width}{A numeric value specifying the base width for saving the plot. Default is \code{5}.}

\item{base_height}{A numeric value specifying the base height for saving the plot. Default is \code{4}.}

\item{output_file}{An optional string specifying the path to save the plot. If \code{NULL}, the plot is not saved. Default is \code{NULL}.}
}
\value{
A ggplot object representing the domino plot.
}
\description{
This function generates a plot to visualize gene expression levels for a given list of genes. The size of the dots can be customized, and the plot can be saved to an output file if specified.
}
