% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space_filling.R
\name{grid_max_entropy}
\alias{grid_max_entropy}
\alias{grid_max_entropy.param_set}
\alias{grid_max_entropy.list}
\alias{grid_max_entropy.param}
\alias{grid_max_entropy.workflow}
\alias{grid_latin_hypercube}
\alias{grid_latin_hypercube.param_set}
\alias{grid_latin_hypercube.list}
\alias{grid_latin_hypercube.param}
\alias{grid_latin_hypercube.workflow}
\title{Space-filling parameter grids}
\usage{
grid_max_entropy(x, ..., size = 3, original = TRUE,
  variogram_range = 0.5, iter = 1000)

\method{grid_max_entropy}{param_set}(x, ..., size = 3, original = TRUE,
  variogram_range = 0.5, iter = 1000)

\method{grid_max_entropy}{list}(x, ..., size = 3, original = TRUE,
  variogram_range = 0.5, iter = 1000)

\method{grid_max_entropy}{param}(x, ..., size = 3, original = TRUE,
  variogram_range = 0.5, iter = 1000)

\method{grid_max_entropy}{workflow}(x, ..., size = 3, original = TRUE,
  variogram_range = 0.5, iter = 1000)

grid_latin_hypercube(x, ..., size = 3, original = TRUE)

\method{grid_latin_hypercube}{param_set}(x, ..., size = 3,
  original = TRUE)

\method{grid_latin_hypercube}{list}(x, ..., size = 3, original = TRUE)

\method{grid_latin_hypercube}{param}(x, ..., size = 3, original = TRUE)

\method{grid_latin_hypercube}{workflow}(x, ..., size = 3,
  original = TRUE)
}
\arguments{
\item{x}{A \code{param} object, list, or \code{param_set}.}

\item{...}{One or more \code{param} objects (such as \code{\link[=mtry]{mtry()}} or
\code{\link[=penalty]{penalty()}}). None of the objects can have \code{unknown()} values in
the parameter ranges or values.}

\item{size}{A single integer for the total number of parameter value
combinations returned.}

\item{original}{A logical: should the parameters be in the original units or
in the transformed space (if any)?}

\item{variogram_range}{A numeric value greater than zero. Larger values
reduce the likelihood of empty regions in the parameter space.}

\item{iter}{An integer for the maximum number of iterations used to find
a good design.}
}
\description{
Experimental designs for computer experiments are used to construct parameter
grids that try to cover the parameter space such that any portion of the
space has an observed combination that is not too far from it.
}
\details{
The types of designs supported here are latin hypercube designs and designs
that attempt to maximize the determinant of the spatial correlation matrix
between coordinates. Both designs use random sampling of points in the
parameter space.
}
\examples{
grid_max_entropy(
  hidden_units(),
  penalty(),
  epochs(),
  activation(),
  learn_rate(c(0, 1), trans = scales::log_trans()),
  size = 10,
  original = FALSE)

grid_latin_hypercube(penalty(), mixture(), original = TRUE)
}
\references{
Sacks, Jerome & Welch, William & J. Mitchell, Toby, and Wynn, Henry.
(1989). Design and analysis of computer experiments. With comments and a
rejoinder by the authors. Statistical Science. 4. 10.1214/ss/1177012413.

Santner, Thomas, Williams, Brian, and Notz, William. (2003). The Design and
Analysis Computer Experiments. Springer.

Dupuy, D., Helbert, C., and Franco, J. (2015). DiceDesign and DiceEval: Two R
packages for design and analysis of computer experiments. Journal of
Statistical Software, 65(11)
}
