% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fpca.dfrr.R
\name{plot.fpca.dfrr}
\alias{plot.fpca.dfrr}
\title{Plot dfrr functional principal components}
\usage{
\method{plot}{fpca.dfrr}(
  x,
  plot.eigen.functions = TRUE,
  select = NULL,
  plot.contour = FALSE,
  plot.3dsurface = FALSE,
  plot.contour.pars = list(breaks = NULL, minor_breaks = NULL, n.breaks = NULL, labels
    = NULL, limits = NULL, colors = NULL, xlab = NULL, ylab = NULL, title = NULL),
  plot.3dsurface.pars = list(xlab = NULL, ylab = NULL, zlab = NULL, title = NULL,
    colors = NULL),
  ask.hit.return = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{fpca.dfrr}-object to be plotted. It is the output of the function \code{\link{fpca}()}}

\item{plot.eigen.functions}{a \code{boolean} indicating whether to print the principal components/eigen-functions. Defaults to TRUE.}

\item{select}{a vector of length one or more of indices of eigenfunctions to be plotted.}

\item{plot.contour}{a \code{boolean} indicating whether to print the contour plot of the kernel function.
It requires \code{\link[ggplot2]{ggplot2-package}} to be installed. Defaults to FALSE.}

\item{plot.3dsurface}{a \code{boolean} indicating whether to print the 3d surface plot of the kernel function.
It requires the package \code{\link[plotly]{plotly}} to be installed. Defaults to FALSE.}

\item{plot.contour.pars}{a named list of graphical parameters passed to the function \code{\link[ggplot2]{ggplot}}.}

\item{plot.3dsurface.pars}{a named list of graphical parameters passed to the function \code{\link[plotly]{plot_ly}}.}

\item{ask.hit.return}{a boolean indicating whether to wait for interaction of the user between any two plots.}

\item{...}{graphical parameters passed to \code{plot} function in drawing 2D eigenfunctions.}
}
\value{
This function generates the plot of principal components.
}
\description{
Plot a \code{fpca.dfrr} object.
}
\details{
This function plots the functional principal components,  contour plot and 3d surface of
the kernel function.

If \code{\link[ggplot2]{ggplot2-package}} is installed, the contour plot of
 the kernel function is produced by setting the argument \code{plot.contour=TRUE}.
 Some graphical parameters of the contour plot can be modified by setting the (optional) argument
 \code{plot.contour.pars}.

 If the package \code{\link[plotly]{plotly}} is installed, the 3d surface  of
 the kernel function is produced by setting the argument \code{plot.3dsurface=TRUE}.
 Some graphical parameters of the 3d surface can be modified by setting the (optional) argument
 \code{plot.3dsurface.pars}.
}
\examples{
set.seed(2000)
\donttest{N<-50;M<-24}
\dontshow{N<-30;M<-12}
X<-rnorm(N,mean=0)
time<-seq(0,1,length.out=M)
Y<-simulate_simple_dfrr(beta0=function(t){cos(pi*t+pi)},
                        beta1=function(t){2*t},
                        X=X,time=time)

 #The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
dfrr_fit<-dfrr(Y~X,yind=time,T_E=1)
fpcs<-fpca(dfrr_fit)
\donttest{plot(fpcs,plot.eigen.functions=TRUE,plot.contour=TRUE,plot.3dsurface=TRUE)}

}
