% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as.data.frame.dfm}
\alias{as.data.frame.dfm}
\title{Extract Factor Estimates in a Data Frame}
\usage{
\method{as.data.frame}{dfm}(
  x,
  ...,
  method = "all",
  pivot = c("long", "wide.factor", "wide.method", "wide", "t.wide"),
  time = seq_row(x$F_pca),
  stringsAsFactors = TRUE
)
}
\arguments{
\item{x}{an object class 'dfm'.}

\item{\dots}{not used.}

\item{method}{character. The factor estimates to use: any of \code{"qml"}, \code{"2s"}, \code{"pca"} (multiple can be supplied) or \code{"all"} for all estimates.}

\item{pivot}{character. The orientation of the frame: \code{"long"}, \code{"wide.factor"} or \code{"wide.method"}, \code{"wide"} or \code{"t.wide"}.}

\item{time}{a vector identifying the time dimension, or \code{NULL} to omit a time variable.}

\item{stringsAsFactors}{make factors from method and factor identifiers. Same as option to \code{\link{as.data.frame.table}}.}
}
\value{
A data frame of factor estimates.
}
\description{
Extract Factor Estimates in a Data Frame
}
\examples{
\donttest{
library(xts)
# Fit DFM with 3 factors and 3 lags in the transition equation
mod = DFM(diff(BM14_M), r = 3, p = 3)

# Taking a single estimate:
print(head(as.data.frame(mod, method = "qml")))
print(head(as.data.frame(mod, method = "qml", pivot = "wide")))

# Adding a proper time variable
time = index(BM14_M)[-1L]
print(head(as.data.frame(mod, method = "qml", time = time)))

# All estimates: different pivoting methods
for (pv in c("long", "wide.factor", "wide.method", "wide", "t.wide")) {
   cat("\npivot = ", pv, "\n")
   print(head(as.data.frame(mod, pivot = pv, time = time), 3))
}
}

}
