% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfidx.R
\name{unfold_idx}
\alias{unfold_idx}
\alias{fold_idx}
\title{Fold and Unfold a dfidx object}
\usage{
unfold_idx(x)

fold_idx(x, pkg = NULL)
}
\arguments{
\item{x}{a \code{dfidx} object}

\item{pkg}{if not \code{NULL}, this argument is passed to \code{dfidx}}
}
\value{
a \code{data.frame} for the \code{unfold_dfidx} function, a \code{dfidx}
object for the \code{fold_dfidx} function
}
\description{
\code{fold_idx} takes a dfidx, includes the indexes as stand alone
columns, remove the \code{idx} column and return a data.frame, with an
\code{ids} attribute that contains the informations about the
indexes. \code{fold_idx} performs the opposite operation
}
\examples{
if (requireNamespace("AER")){
data("TravelMode", package = "AER")
TM <- dfidx(TravelMode)
TM2 <- unfold_idx(TM)
attr(TM2, "ids")
TM3 <- fold_idx(TM2)
identical(TM, TM3)
}
}
\author{
Yves Croissant
}
