% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d3c.R
\name{add_test3DC}
\alias{add_test3DC}
\title{Add a standard setting booklet to a 3DC database}
\usage{
add_test3DC(db3dc, parms, design, test_id, standards, mu, sigma,
  population = NULL, group_leader = "admin", omit = 0)
}
\arguments{
\item{db3dc}{3dc database handle}

\item{parms}{a parameters object produced by fit_enorm}

\item{design}{a data.frame with columns item_id, cluster and optionally cluster_nbr (used for sorting the clusters) 
and item_nbr (used for sorting items within cluster).}

\item{test_id}{name/id of the test as it will be shown in the 3DC application.}

\item{standards}{vector of standards to be set}

\item{mu}{expected ability in population, used for scaling of the clusters}

\item{sigma}{expected standard deviation of ability in population, used for scaling of the clusters}

\item{population}{optionally a data.frame with columns test_score and frequency to use for visualization in 3DC 
application. If NULL, the distribution will be derived from a simulation.}

\item{group_leader}{Login name of the group leader, default is admin. The default password is always
admin, but can be changed in the 3DC application.}

\item{omit}{the tail probability of the testscores to be omitted from the 3DC form. For example, if set to 0.1, 
the 10% highest and the 10% lowest scores will be omitted thus restricting the range on which standards can be set.
The Default is 0.0 (omit nothing)}
}
\description{
See create3DC for more information
}
