% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equating.R
\name{probability_to_pass}
\alias{probability_to_pass}
\title{The probability to pass on a reference test given a score on a new booklet}
\usage{
probability_to_pass(dataSrc, ref_items, pass_fail, design = NULL,
  predicate = NULL, similar_groups = TRUE)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score and booklet_id}

\item{ref_items}{vector with id's of items in the reference set, they must all occur in dataSrc}

\item{pass_fail}{pass-fail score on the reference set}

\item{design}{A data.frame with columns booklet_id (if multiple booklets) and item_id defining the target test booklet(s), 
if NULL (default) this will be derived from the dataSrc and the probability to pass will be computed 
for each test score for each booklet in your data.}

\item{predicate}{An optional expression to subset data in dataSrc, if NULL all data is used}

\item{similar_groups}{When TRUE it is assumed that candidates taking the reference test and the target tests are similar 
in ability. If they are similar, the score distribution on the target test is estimated more precisely. 
Works only when design contains booklet_id's.}
}
\value{
An object of type p2pass. Use \code{coef()} to extract the 
probablity to pass for each booklet and score. Use \code{plot()} to plot 
the probabilities, sensitivity and specificity.
}
\description{
Given response data that form a connected design,
compute the probability to pass on the reference set conditional on each score on one or more target tests.
}
\details{
Note that this function is computationally intensive and can take a long time to run, especially when computing the
probability to pass for multiple target booklets.


For any possible score k, we use a Gibbs sampler to calculate 
\ifelse{html}{
  \out{<p><i>P(Y<sub>+</sub> &#8805; c | X<sub>+</sub>=k, <span style="font-weight:bold;">x</span> ) = 
             <span style="font-size:150\%;">&#8747;</span><sub><span style="font-weight:bold;">b</span>,&theta;</sub> 
             P(Y<sub>+</sub> &#8805; c | &theta;, <span style="font-weight:bold;">b</span>)&#8729;&#402;(<span style="font-weight:bold;">b</span> | <span style="font-weight:bold;">x</span>)&#8729;d<span style="font-weight:bold;">b</span>&theta;
             </i></p>}
}{\deqn{P(Y_+ \geq c|X_+ = k,\mathbf{x})
     = \int_{\mathbf{b},\theta} 
            P(Y_+ \geq c|\theta,\mathbf{b}) 
            f(\theta|X_+ = k) f(\mathbf{b}|\mathbf{x})
     d\mathbf{b},\theta}} 

where:
\describe{
   \item{\eqn{\theta}}{is student ability}
   \item{\eqn{b}}{are the item parameters}
   \item{\ifelse{html}{\out{<i>Y<sub>+</sub></i>}}{\eqn{Y_+}}}{is the score on the reference test}
   \item{\eqn{c}}{is an established pass_fail score on the reference test}
   \item{\ifelse{html}{\out{<i>X<sub>+</sub></i>}}{\eqn{X_+}}}{is the score on the booklet}
   \item{\eqn{x}}{are the observed data}
 }
This probability can be used to establish a pass-fail score for the new booklet.
}
