% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\docType{class}
\name{Node-class}
\alias{Node-class}
\title{Node Class Definition}
\value{
An object of class \code{Node}.
}
\description{
An S4 class to represent a node in a tree structure.
}
\details{
A structured representation of a node, which encompasses various attributes
such as name, depth, and relationships with other nodes in the tree structure.
The class \code{Node} is primarily used in the creation, manipulation, and
display of nodes within tree structures.
}
\section{Slots}{

\describe{
\item{\code{Id}}{\code{numeric} - Unique sequential identifier for the node.}

\item{\code{Name}}{\code{character} - Name of the node.}

\item{\code{IsLeaf}}{\code{logical} - Flag indicating if the node is a leaf.}

\item{\code{IsLeafAndAggregated}}{\code{logical} - Flag indicating if the node is both
a leaf and an aggregated node.}

\item{\code{Children}}{\code{character} - List of the node's children names.}

\item{\code{Sisters}}{\code{character} - List of the node's sisters names.}

\item{\code{Mother}}{\code{character} - Name of the node's mother.}

\item{\code{Aggregation}}{\code{matrix} - Aggregation table if the node is aggregated.}

\item{\code{Probability}}{\code{numeric} - Estimated weight for aggregation.}

\item{\code{Depth}}{\code{numeric} - Depth of the node in the tree.}

\item{\code{Twin}}{\code{numeric} - ID of the other leaves for nodes with multiple
leaves.}

\item{\code{ConditionalProbabilityList}}{\code{list} - List storing conditional
probabilities.}

\item{\code{RangeScale}}{\code{numeric} - Range scale for the node.}

\item{\code{ScaleLabel}}{\code{character} - Labels corresponding to different scales.}

\item{\code{NodePath}}{\code{character} - Path from the root to the leaf for the node.}
}}

\seealso{
\itemize{
\item \code{\link{print.Node}}: For printing a Node object.
}
}
