% Generated by roxygen2 (4.0.2): do not edit by hand
\name{infrastructure}
\alias{add_rstudio_project}
\alias{add_test_infrastructure}
\alias{add_travis}
\alias{infrastructure}
\alias{use_package_doc}
\alias{use_rcpp}
\alias{use_rstudio}
\alias{use_testthat}
\alias{use_travis}
\alias{use_vignette}
\title{Add useful infrastructure to a package.}
\usage{
use_testthat(pkg = ".")

use_rstudio(pkg = ".")

use_vignette(name, pkg = ".")

use_rcpp(pkg = ".")

use_travis(pkg = ".")

use_package_doc(pkg = ".")
}
\arguments{
\item{pkg}{package description, can be path or package name. See
\code{\link{as.package}} for more information.}

\item{name}{File name to use for new vignette. Should consist only of
numbers, letters, _ and -. I recommend using lower case.}
}
\description{
Add useful infrastructure to a package.
}
\section{\code{use_testthat}}{

Add testing infrastructure to a package that does not already have it.
This will create \file{tests/testthat.R}, \file{tests/testthat/} and
add \pkg{testthat} to the suggested packages. This is called
automatically from \code{\link{test}} if needed.
}

\section{\code{use_rstudio}}{

Does not modify \code{.Rbuildignore} as RStudio will do that when
opened for the first time.
}

\section{\code{use_knitr}}{

Adds needed packages to \code{DESCRIPTION}, and creates draft vignette
in \code{vignettes/}. It adds \code{inst/doc} to \code{.gitignore}
so you don't accidentally check in the built vignettes.
}

\section{\code{use_rcpp}}{

Creates \code{src/} and adds needed packages to \code{DESCRIPTION}.
}

\section{\code{use_travis}}{

Add basic travis template to a package. Also adds \code{.travis.yml} to
\code{.Rbuildignore} so it isn't included in the built package.
}

\section{\code{use_package_doc}}{

Adds a roxygen template for package documentation
}
\seealso{
Other infrastructure: \code{\link{add_build_ignore}},
  \code{\link{use_build_ignore}};
  \code{\link{use_data_raw}}; \code{\link{use_data}};
  \code{\link{use_package}}
}

