% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{shi_11}
\alias{shi_11}
\title{Shi equation of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation as a formula object.}
  \item{eqAlt}{The equation as a string.}
  \item{name}{The equation name.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameter values found in the literature with their references.}
  \item{com}{An otional comment about the equation use.}
  \item{id}{An id to identificate the equation.}
}}
\source{
\url{http://dx.doi.org/10.1016/j.aspen.2010.11.008}
}
\usage{
shi_11
}
\description{
Shi, P., Ge, F., Sun, Y., and Chen, C. (2011) A simple model for describing the effect of
temperature on insect developmental rate. Journal of Asia-Pacific Entomology 14(1): 15-20.
}
\details{
Equation:
rT ~ cc * (1 - exp(-k1 * (T - T1))) * (1 - exp(k2 * (T - T2)))

where rT is the development rate, T the temperature, T1 and T2 the conceptual
lower and upper developmental thresholds at which development rates equal zero,
and cc k1, and k2 constants.
}
\keyword{datasets}

