% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hilbertLogan_83}
\alias{hilbertLogan_83}
\title{Holling type III equation of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation as a formula object.}
  \item{eqAlt}{The equation as a string.}
  \item{name}{The equation name.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameter values found in the literature with their references.}
  \item{com}{An otional comment about the equation use.}
  \item{id}{An id to identificate the equation.}
}}
\source{
\url{http://dx.doi.org/10.1093/ee/12.1.1}
}
\usage{
hilbertLogan_83
}
\description{
Hilbert, DW, y JA Logan (1983) Empirical model of nymphal development for the migratory
grasshopper, Melanoplus sanguinipes (Orthoptera: Acrididae).
Environmental Entomology 12(1): 1-5.
}
\details{
Equation:
rT ~ phi * (((T-Tb)^2 / ((T-Tb)^2 + aa^2)) - exp(-(Tmax - (T-Tb))/deltaT))

where rT is the development rate, T the temperature, Tb the minimum
temperature for development, deltaT the width of high temperature boundary area,
Tmax the maximum temperature, and aa a constant.
}
\keyword{datasets}

