% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pillar_stats.R
\name{pillar-stats}
\alias{pillar-stats}
\alias{sum_pillars}
\alias{mean_pillars}
\alias{median_pillars}
\alias{var_pillars}
\title{Get the sums/means/medians/variances of pillars of an
\link[ijtiff:ijtiff_img]{ijtiff_img}-style array.}
\usage{
sum_pillars(img, parallel = FALSE)

mean_pillars(img, parallel = FALSE)

median_pillars(img, parallel = FALSE)

var_pillars(img, parallel = FALSE)
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\value{
An \link[ijtiff:ijtiff_img]{ijtiff_img}-style array \code{arr} with one frame.
\code{arr[y, x, ch, 1]} is equal to \code{mean(img[y, x, ch, ])}, \code{median(img[y, x, ch, ])}, or \code{var(img[y, x, ch, ])}.
}
\description{
For an \link[ijtiff:ijtiff_img]{ijtiff_img}-style array \code{img} (indexed as \code{img[y, x, channel, frame]}), pillar \code{xy} of channel
\code{ch} is defined as \code{img[y, x, ch, ]}. These functions compute the mean,
median and variance of each pillar for each channel.
}
\examples{
aaa <- array(seq_len(2 ^ 4), dim = rep(2, 4))  # a 2-channel, 2-frame array
sum_pillars(aaa)
mean_pillars(aaa)
median_pillars(aaa)
var_pillars(aaa)

}
