% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/det1.R
\name{det1}
\alias{det1}
\title{Density Estimation for Univariate Data Based on Distribution Element Trees}
\usage{
det1(x, mode = 2, bounds = c(0, 0), alpha = 0.001, main = NULL,
  cores = 0)
}
\arguments{
\item{x}{vector with data points.}

\item{mode}{order of distribution elements applied, default is \code{mode = 2}. Use \code{+/-1} for constant or \code{+/-2} for linear elements. \code{mode > 0} and \code{mode < 0} lead to equal-size and -score splits, respectively, in the element-refinement process.}

\item{bounds}{\code{c(lb,ub)}, where \code{lb} and \code{ub} are lower and upper bounds of the probability space. If both bounds are set to 0 (default), the bounds are determined based on the data \code{x}.}

\item{alpha}{significance level for goodness-of-fit testing in element refinement or splitting process. Default is \code{alpha = 1.0e-3}.}

\item{main}{an overall plot title, see \code{\link[graphics]{title}}.}

\item{cores}{number of cores for parallel tree construction. Default is \code{0} for automatic allocation, see \code{\link{det.construct}}.}
}
\description{
One-dimensional piecewise linear or constant probability density estimator based on distribution element trees (DETs).
}
\examples{
require(stats)
det1(rnorm(1e4), mode = 2, cores = 1)
det1(runif(1e4), mode = -1, bounds = c(-1,1.5), cores = 2)
det1(rbeta(1e4, shape1 = 1.05, shape2 = 0.8), mode = -1, bounds = c(-0.1,1.1), cores = 1)
det1(rbeta(1e4, shape1 = 1.05, shape2 = 0.8), mode = -2, bounds = c(-0.1,1.1), cores = 1)
}
