% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectSliding.R
\name{detectSliding}
\alias{detectSliding}
\title{Change point detection using PCA and sliding method}
\usage{
detectSliding(
  Y,
  wd = 40,
  L,
  Del,
  q = "fixed",
  alpha = 0.05,
  nboot = 199,
  n.cl,
  bsize = "log",
  bootTF = TRUE,
  scaleTF = TRUE,
  diagTF = TRUE,
  plotTF = TRUE
)
}
\arguments{
\item{Y}{data: Y = length*dim}

\item{wd}{window size for sliding averages}

\item{L}{the number of factors}

\item{Del}{Delta away from the boundary restriction}

\item{q}{methods in calculating long-run variance of the test statistic. Defaul is "andrew" "fixed" = length^{1/3} or user specify the length}

\item{alpha}{significance level of the test}

\item{nboot}{the number of bootstrap sample for pvalue. Defauls is 199.}

\item{n.cl}{number of cores in parallel computing. The default is (machine cores - 1)}

\item{bsize}{block size for the Block Wild Boostrapping. Default is log(length),  "sqrt" uses sqrt(length), "adaptive" deterines block size usign data dependent selection of Andrews}

\item{bootTF}{determine whether the threshold is calculated from bootstrap or asymptotic}

\item{scaleTF}{scale the variance into 1}

\item{diagTF}{include diagonal term of covariance matrix or not}

\item{plotTF}{Draw plot to see test statistic and threshould}
}
\value{
\strong{sW} The test statistic

\strong{L} The number of factors used in the procedure

\strong{q} The estimated vecorized autocovariance on each regime.

\strong{crit} The critical vlaue to identify change point

\strong{bsize} The block size of the bootstrap

\strong{diagTF} If TRUE, the diagonal entry of covariance matrix is used in detecting connectivity changes.

\strong{bootTF} If TRUE, boostrap is used to find critical value

\strong{scaleTF} If TRUE, the multivariate signal is studentized to have zero mean and unit variance.
}
\description{
Change point detection using PCA and sliding method
}
\examples{
\donttest{out4 = detectSliding(changesim, wd=40, L=2, n.cl=1)}
}
