\name{par.f.test}
\alias{par.f.test}
\title{F-test on Multiple Linear Combinations of Estimated Parameters in a Linear Model}
\usage{
par.f.test(
  mod,
  data = list(),
  nh,
  q = rep(0, dim(nh)[1]),
  sig.level = 0.05,
  details = FALSE,
  hyp = TRUE
)
}
\arguments{
\item{mod}{model object estimated by \code{ols()} or \code{lm()}.}
\item{data}{name of the data frame to be used if \code{mod} is only a formula.}
\item{nh}{matrix of the coefficients of the linear combination of parameters. Each of the L rows of that matrix represents a linear combination.}
\item{q}{L-dimensional vector of values on which the parameter (combination) is to be tested against. Default value is the null-vector.}
\item{sig.level}{significance level. Default value: \code{sig.level = 0.05}.}
\item{details}{logical value indicating whether specific details about the test should be returned.}
\item{hyp}{logical value indicating whether the hypotheses should be part of the output. To be disabled if output is too large.}
}
\value{
A list object including:
\tabular{ll}{
\code{hyp} \tab character matrix of hypotheses (if \code{hyp = TRUE}).\cr
\code{nh} \tab linear combinations tested in the null hypothesis (in matrix form).\cr
\code{q} \tab vector of values the linear combinations are tested on.\cr
\code{mod} \tab the model passed to \code{par.f.test}.\cr
\code{results} \tab a data frame of basic test results.\cr
\code{SSR.H0} \tab sum of squared residuals in H0-model.\cr
\code{SSR.H1} \tab sum of squared residuals in regular model.\cr
\code{nulldist}\tab type of the null distribution with its parameters.\cr
}
}
\description{
Performs an F-test (non-directional) on multiple (L) linear combinations of parameters in a linear model.
}
\details{
Objects x generated by \code{par.f.test} can be plotted using \code{plot(x, plot.what = ...)}. Argument \code{plot.what} can have the following values:
\tabular{ll}{
\code{"dist"} \tab plot the null distribution, test statistics and p-values.\cr
\code{"ellipse"} \tab plot acceptance ellipse.\cr
}
If \code{plot.what = "ellipse"} is specified, further arguments can be passed to \code{plot()}:
\tabular{ll}{
\code{type = "acceptance"} \tab plot acceptance ellipse ("acceptance") or confidence ellipse ("confidence").\cr
\code{which.coef = c(2,3)} \tab for which two coefficients should the ellipse be plotted?\cr
\code{center = TRUE} \tab plot center of ellipse.\cr
\code{intervals = TRUE} \tab	plot interval borders.\cr
\code{test.point = TRUE} \tab plot the point (q-values or coefficients) used in F-Test.\cr
\code{q = c(0,0)} \tab	the q-value used in acceptance ellipse.\cr
\code{sig.level = 0.05} \tab	significance level used.\cr
}
}
\examples{
## H0: beta1 = 0.33 and beta2 = 0
x <- par.f.test(barley ~ phos + nit, data = log(data.fertilizer),
                 nh = rbind(c(0,1,0), c(0,0,1)),
                 q = c(0.33,0.33),
                 details = TRUE)
x # Show the test results

plot(x) # Visualize the test result
plot(x, plot.what = "ellipse", q = c(0.33, 0.33))

}
\concept{F-test}
\concept{linear combination}
\concept{linear hypothesis}
\concept{linear model}
