% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{s_semiarma}
\alias{s_semiarma}
\title{Fitting of a Seasonal Semiparametric ARMA Model}
\usage{
s_semiarma(
  yt,
  smoothing_options = set_options(),
  arma_options = list(ar_order = NULL, ma_order = NULL),
  bwidth_start = 0.2,
  inflation_rate = c("optimal", "naive"),
  correction_factor = FALSE,
  drop = NULL,
  error_model = c("free", "ARMA"),
  nar_lim = c(0, 3),
  nma_lim = c(0, 3),
  arma_mean = FALSE
)
}
\arguments{
\item{yt}{a numerical vector or a time series object of class \code{ts} or 
that can be transformed with \code{\link[stats]{as.ts}} to an object of class 
\code{ts}; for these observations, trend and seasonality will be obtained.}

\item{smoothing_options}{an S4 object of class \code{smoothing_options}, which 
is returned by the function \code{\link{set_options}}; it 
includes details about the
options to consider in the locally weighted regression, such as the order of
polynomial and the bandwidth for smoothing among others, for the nonparametric
part of the model; the nonparametric model is fitted using 
\code{\link{deseats}}.}

\item{arma_options}{a list with the two elements \code{ar_order} and 
\code{ma_order} that indicates the AR and MA orders to consider for the 
parametric part of the model.}

\item{bwidth_start}{a single numeric value that is only relevant if the slot
\code{bwidth} in \code{smoothing_options} is set to \code{NA}; 
as the bandwidth will then
be selected automatically, \code{bwidth_start} sets the initial bandwidth for 
the algorithm.}

\item{inflation_rate}{a character vector of length one that indicates, which inflation rate 
to use in the bandwidth selection; for a local linear trend, we have 
\code{inflation_rate = "optimal"} as the default, for a local cubic trend
it is \code{inflation_rate = "naive"}, which correspond to inflation rates
of 5/7 and 9/13, respectively.}

\item{correction_factor}{A logical vector of length one; theoretically, a 
larger bandwidth to estimate the sum of autocovariances from residuals of 
pilot trend and seasonality estimates is advisable than for estimating trend
and seasonality; for \code{correction_factor = TRUE}, this is implemented;
for \code{error_model = "ARMA"}, \code{correction_factor = FALSE} is 
enforced; the default is \code{correction_factor = FALSE}, because it was
found that setting this argument to \code{TRUE} often overestimates the 
bandwidth.}

\item{drop}{a numeric vector of length one that indicates the proportion of 
the observations to not include at each boundary in the bandwidth estimation 
process, if a bandwidth is selected automatically; the default is 
\code{drop = 0.1}.}

\item{error_model}{a character vector of length one that indicates whether
for \code{autocor = TRUE} the sum of autocovariances of the errors is 
obtained purely nonparametrically (\code{"free"}) or whether an
autoregressive moving-average (ARMA) model is assumed \code{"ARMA"}; the
default is \code{error_model = "free"}.}

\item{nar_lim}{only valid for \code{error_model = "ARMA"}; set the minimum and 
maximum AR order to check via the BIC in each iteration of the algorithm via 
a two-element vector.}

\item{nma_lim}{only valid for \code{error_model = "ARMA"}; set the minimum and
maximum MA order to check via the BIC in each iteration of the algorithm via
a two-element vector.}

\item{arma_mean}{only valid for \code{error_model = "ARMA"}; decide whether to 
include an estimate of the mean in the ARMA fitting for the detrended series.}
}
\value{
The function returns and S4 object with the following elements (access them 
via \code{@}):
\describe{
\item{\code{decomp}}{an object of class \code{"mts"} that includes the 
observed time series and its estimated components.}
\item{\code{nonpar_model}}{an object of class \code{"deseats"}; this is 
the result of applying \code{\link{deseats}}.}
\item{\code{par_model}}{an object of class \code{"Arima"}; the result of 
applying \code{\link[stats]{arima}} to the residuals of the nonparametric 
estimation step.}
}
}
\description{
Fit a seasonal semiparametric autoregressive moving-average 
(S-Semi-ARMA) model to a univariate time series. The estimation is 
in two steps: firstly, the series is detrended and seasonally adjusted using the
function \code{\link{deseats}}. Then an ARMA model is fitted to the 
residuals using \code{\link[stats]{arima}}.
}
\details{
For information on the nonparametric regression step, see 
\code{\link[deseats]{deseats}}. After the trend and the seasonality have 
been removed from the data, an autoregressive moving-average (ARMA) model
is fitted to the residuals either with orders selected by the Bayesian
information criterion (BIC) or with manually selected orders. The ARMA
model is fitted using \code{\link[stats]{arima}}.

All function arguments except for \code{arma_options} are identical to 
those in \code{\link[deseats]{deseats}}. If all elements in 
\code{arma_options} are set to \code{NULL}, the ARMA model orders are 
selected for \eqn{p, q} from \code{nar_lim[[1]]} and \code{nma_lim[[1]]} up
until \code{nar_lim[[2]]} and \code{nma_lim[[2]]} according to the BIC.
}
\examples{
\donttest{
Xt <- log(EXPENDITURES)
est <- s_semiarma(Xt)
est
}

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
\item Yuanhua Feng (Department of Economics, Paderborn
University), \cr
Author
}
}
