% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-deseats.R
\name{animate,deseats-method}
\alias{animate,deseats-method}
\title{Animate Locally Weighted Regression Results}
\usage{
\S4method{animate}{deseats}(
  object,
  col.obs = "grey74",
  col.fit = "red",
  col.weights = "#00D40E",
  col.window = "deepskyblue4",
  col.spot = "orange",
  save = NULL,
  xlab = "Time",
  ylab1 = "Estimated trend + seasonality",
  ylab2 = "Active kernel weights",
  main = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"deseats"}.}

\item{col.obs}{the color to use for the observations.}

\item{col.fit}{the color to use for the fitted values.}

\item{col.weights}{the color to use for the active kernel weights.}

\item{col.window}{the color to use for the window defined through the
bandwidth}

\item{col.spot}{the color to highlight the estimation time point.}

\item{save}{whether to save the animation or not; for \code{NULL},
it will not be saved; to save it in the current working directory, use 
either \code{save = "PDF"} or \code{save = "HTML"}, which also specifies 
the file format.}

\item{xlab}{the label for the x-axis.}

\item{ylab1}{the label for the y-axis on the left-hand side.}

\item{ylab2}{the label for the second y-axis on the right-hand side.}

\item{main}{the plot title.}

\item{...}{currently without use; implemented for possible future 
compatibility.}
}
\value{
The function returns \code{NULL}.
}
\description{
The results of locally weighted regression results
acquired through decomposition of seasonal time series 
via the function \code{\link{deseats}} can be 
animated automatically.
}
\details{
\code{\link{deseats}} estimation results are automatically animated 
through this method. It shows the observed series together with fitted
values (trend + seasonality), the smoothing window, the fitted values from 
the local regression, and the active kernel weights.
}
\examples{
\donttest{
### Creating the animation might take a while
Xt <- log(EXPENDITURES)
smoothing_options <- set_options(order_poly = 3)
est <- deseats(Xt, smoothing_options = smoothing_options)
animate(est)
}

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
