% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-deseats_fc.R
\name{plot,deseats_fc-method}
\alias{plot,deseats_fc-method}
\title{Plot Method for Class \code{"deseats_fc"}}
\usage{
\S4method{plot}{deseats_fc}(x, y = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{"deseats_fc"}, for example generated by a 
call to \code{\link{predict,s_semiarma-method}}.}

\item{y}{currently without use; for compatibility only.}

\item{...}{further arguments of \code{\link[stats]{plot.ts}} to adjust 
for example the axis limits via \code{xlim} and \code{ylim}.}
}
\value{
This method returns \code{NULL}.
}
\description{
Create basic R plots for forecasting objects of class \code{"deseats_fc"}.
}
\details{
This is a plot method to visualize the forecasting results for a Seasonal 
Semi-ARMA model. Common plot arguments can be implemented to change the 
appearance.
}
\examples{
\donttest{
est <- s_semiarma(log(EXPENDITURES))
fc <- predict(est, n.ahead = 4)
fc_e <- expo(fc)
plot(fc_e)
}

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
