% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.dendlist.R
\name{cor_FM_index}
\alias{cor_FM_index}
\title{Correlation of FM_index for some k}
\usage{
cor_FM_index(dend1, dend2, k, ...)
}
\arguments{
\item{dend1}{a dendrogram.}

\item{dend2}{a dendrogram.}

\item{k}{an integer (number of clusters to cut the tree)}

\item{...}{not used.}
}
\value{
A correlation value between 0 to 1 (almost identical clusters for some k)
}
\description{
Calculates the FM_index Correlation for some k.
}
\examples{

set.seed(23235)
ss <- sample(1:150, 10 )
hc1 <- iris[ss,-5] \%>\% dist \%>\% hclust("com")
hc2 <- iris[ss,-5] \%>\% dist \%>\% hclust("single")
dend1 <- as.dendrogram(hc1)
dend2 <- as.dendrogram(hc2)

cor_FM_index(dend1, dend2, k = 2)
cor_FM_index(dend1, dend2, k = 3)
cor_FM_index(dend1, dend2, k = 4)

}
\seealso{
\link{FM_index}, \link{cor.dendlist}, \link{Bk}
}
