% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noded_with_condition.R
\name{which_leaf}
\alias{which_leaf}
\title{Which node is a leaf?}
\usage{
which_leaf(dend, ...)
}
\arguments{
\item{dend}{a dendrogram dend}

\item{...}{ignored.}
}
\value{
A logical vector with the length of \link{nnodes}, 
which gives a TRUE when a node is a leaf.
}
\description{
Gives a vector as the number of nodes (\link{nnodes}), 
which gives a TRUE when a node is a leaf.
}
\examples{
\dontrun{

library(dendextend)

# Getting the dend dend
set.seed(23235)
ss <- sample(1:150, 10 )
dend <- iris[ss,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend \%>\% plot

which_leaf(dend)

}
}
\seealso{
\link{noded_with_condition}, \link{is.leaf}, \link{nnodes}
}

