\name{compare.demogdata}
\alias{compare.demogdata}
\title{Evaluation of demographic forecast accuracy}
\usage{compare.demogdata(data, forecast, series=names(forecast$rate)[1],
    ages = data$age, max.age=min(max(data$age),max(forecast$age)), 
    years=data$year, interpolate=FALSE)

}

\arguments{
\item{data}{Demogdata object such as created using \code{\link{read.demogdata}} containing actual demographic rates.}
\item{forecast}{Demogdata object such as created using \code{\link{forecast.fdm}} or \code{\link{forecast.lca}}.}
\item{series}{Name of series to use. Default: the first matrix within \code{forecast$rate}.}
\item{ages}{Ages to use for comparison. Default: all available ages.}
\item{max.age}{Upper age to use for comparison.}
\item{years}{Years to use in comparison. Default is to use all available years that are common between data and forecast.}
\item{interpolate}{If TRUE, all zeros in data are replaced by interpolated estimates when computing the error measures
 on the log scale. Error measures on the original (rate) scale are unchanged.}
}

\description{Computes mean forecast errors and mean square forecast errors for each age level.
Computes integrated squared forecast errors and integrated absolute percentage forecast errors for each year.}


\value{Object of class "errorfdm" with the following components:
\item{label}{Name of region from which data taken.}
\item{age}{Ages from \code{data} object.}
\item{year}{Years from \code{data} object.}
\item{<error>}{Matrix of forecast errors on rates.}
\item{<logerror>}{Matrix of forecast errors on log rates.}
\item{mean.error}{Various measures of forecast accuracy averaged across years.
    Specifically ME=mean error, MSE=mean squared error,
    MPE=mean percentage error and MAPE=mean absolute percentage error.}
\item{int.error}{Various measures of forecast accuracy integrated across ages.
    Specifically IE=integrated error, ISE=integrated squared error,
    IPE=integrated percentage error and IAPE=integrated absolute percentage error.}
\item{life.expectancy}{If \code{data$type="mortality"}, function returns this component which is a matrix
    containing actual, forecast and actual-forecast for life expectancies.}
Note that the error matrices have different names indicating if the series forecast was male, female or total.
}

\author{Rob J Hyndman}

\seealso{\link{forecast.fdm},\link{plot.errorfdm}}

\examples{
fr.test <- smooth.demogdata(extract.years(fr.mort,years=1921:1980))
fr.fit <- fdm(fr.test,order=2)
fr.error <- compare.demogdata(fr.mort, forecast(fr.fit,20))
plot(fr.error)
par(mfrow=c(2,1))
plot(fr.error$age,fr.error$mean.error[,"ME"],
    type="l",xlab="Age",ylab="Mean Forecast Error")
plot(fr.error$int.error[,"ISE"],
    xlab="Year",ylab="Integrated Square Error")
}
\keyword{models}
