\name{kde}
\alias{kde}
\title{
  Univariate kernel density estimation directly in R code.
}
\description{
  This funciton behaves similarly to the \code{density} function of the
  \pkg{stats} package, but uses only R code.  It is a demonstration
  function intended to show how kernel density estimates are
  computed, at least conceptually.  For 
}
\usage{
kde(x, bw = bw.nrd0, kernel = kernelGaussian, n = 4048,
    from = min(x) - 3 * sd, to = max(x) + 3 * sd,
    adjust = 1, ...)
}
\arguments{
  \item{x}{
    Univeriate sample.  Must be numeric.
  }
  \item{bw}{
    Either an explicit numeric bandwidth to be used for the kernel, or a
    function used to calculate it.
  }
  \item{kernel}{
    The kernel function to be used.  Must have the same argument
    sequence as \code{\link{kernelGaussian}}, with the same meanings.
  }
  \item{n}{
    Then number of points covering the range at which to evaluate the
    KDE.  More gives a smoother display of the result; fewer gives a
    quicker and more memory efficient computation.
  }
  \item{from}{
    Lower boundary for the computed KDE.
  }
  \item{to}{
    Upper boundary for the computed KDE.
  }
  \item{adjust}{
    Adjustment factor to be used for the bandwidth.  
  }
  \item{\dots}{
    Additional arguments, if any, to be supplied to the bandwidth
    computation function, (if supplied).
  }
}
\details{
  This is a demonstration function intended to show, via R code, the way
  in which a kernel density estimate is computed.

  For samples which are not too large the computation is reasonably
  efficient, but for serious computations the standard function
  \code{\link[stats]{density}}, or some alternative, should be
  used.
}
\value{
  An object of class \dQuote{density}, with essentially the same
  structure as objects generated by the \code{density}
  of the \pkg{stats} package.  \code{plot} and allied methods should apply.
}
\author{
  Bill Venables
}
\note{
  Demonstration code only!
}

\seealso{
  \code{\link{kernelBiweight}} and aliases; \code{\link[stats]{density}}.
}
\examples{
if(require("graphics")) {
  with(MASS::geyser, {
      hist(waiting, freq=FALSE, main="", border="grey", las=1)
      lines(stats::density(waiting), col="skyblue", lwd=8)
      lines(kde(waiting))
      lines(kde(waiting, kernel = kernelUniform), col="red")
      rug(jitter(waiting), col="blue")
      legend("topleft", c("density histogram",
        "KDE gaussian (denstiy)", "KDE gaussian (kde)",
        "KDE rectangular (kde)"), lty = "solid", lwd=c(1,8,1,1),
        col=c("grey", "skyblue", "black", "red"), bty="n")                 
  })
}
}
\keyword{distribution}
\keyword{dplot}
