% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/DEMIExperiment-methods.R
\docType{methods}
\name{getCytoband}
\alias{getCytoband}
\alias{getCytoband,DEMIExperiment-method}
\title{Returns the \code{cytoband} parameter representing karyotype information}
\usage{
getCytoband(object)

\S4method{getCytoband}{DEMIExperiment}(object)
}
\arguments{
\item{object}{A \code{DEMIExperiment} object.}
}
\value{
Returns the \code{cytoband} paramter of the \code{DEMIExperiment} object that is a \code{data.frame}.
}
\description{
Returns the \code{cytoband} parameter of the \code{DEMIExperiment} object. It is a \code{data.frame} that stores
the karyotype information of the chromosomes.
}
\details{
If the \code{analysis} parameter in \code{DEMIExperiment} object is set to 'genome' then genome sections are
being annotated by their karyotypes. The annotation information is stored in the \code{cytoband} parameter of
the \code{DEMIExperiment} object.
}
\examples{
\dontrun{

# To use the example we need to download a subset of CEL files from
# http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE9819 published
# by Pradervand et al. 2008.

# Set the destination folder where the downloaded files fill be located.
# It can be any folder of your choosing.
destfolder <- "demitest/testdata/"

# Download packed CEL files and change the names according to the feature
# they represent (for example to include UHR or BRAIN in them to denote the
# features).
# It is good practice to name the files according to their features which
# allows easier identification of the files later.

ftpaddress <- "ftp://ftp.ncbi.nlm.nih.gov/geo/samples/GSM247nnn"
download.file( paste( ftpaddress, "GSM247694/suppl/GSM247694.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR01_GSM247694.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247695/suppl/GSM247695.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR02_GSM247695.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247698/suppl/GSM247698.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR03_GSM247698.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247699/suppl/GSM247699.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR04_GSM247699.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247696/suppl/GSM247696.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN01_GSM247696.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247697/suppl/GSM247697.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN02_GSM247697.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247700/suppl/GSM247700.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN03_GSM247700.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247701/suppl/GSM247701.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN04_GSM247701.CEL.gz", sep = "" ) )

# We need the gunzip function (located in the R.utils package) to unpack the gz files.
# Also we will remove the original unpacked files for we won't need them.
library( R.utils )
for( i in list.files( destfolder ) ) {
	gunzip( paste( destfolder, i, sep = "" ), remove = TRUE )
}

# Now we can continue the example of the function getCytoband

# Set up an experiment. Note that the cytoband can only retrieved when the analysis
# has been set to genome.
demiexp_genome <- DEMIExperiment( analysis = 'genome', celpath = destfolder,
		experiment = 'myexperiment', organism = 'homo_sapiens', sectionsize = 500000 )

# Retrieve the 'cytoband' parameter representing karyotype information
head( getCytoband( demiexp_genome ) )

}
}
\author{
Sten Ilmjarv
}
\seealso{
\code{DEMIExperiment}
}

