% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputeMechanism.R
\name{ImputeMechanism.object}
\alias{ImputeMechanism.object}
\title{ImputeMechanism object}
\arguments{
\item{name}{The method name (used for printing)}

\item{cols.needed}{which columns of the SingleSim data frame are required by the method, typically
\code{c("censored.time","observed.events","arm")}}

\item{impute}{A function which takes a \code{SingleSimFit} object and outputs the details for a single
imputed data set, specifically a list with two elements:
\code{new.censored.times} - a vector of times subjects were censored (after taking into account imputation)
and \code{newevent.times} - a list of vectors where the vectors contain the imputed event times for the subjects
(these vectors do not contain the observed event times before subject drop out). If a subject has no imputed events then 
the vector \code{numeric(0)} is returned.}

\item{parameters}{A list of named parameters describing the method (used for printing) - or NULL if none}
}
\description{
An object which defines a mechanism for taking
a \code{SingleSimFit} object and imputing missing data
to create a \code{ImputeSim}
}
\details{
It is possible to create user defined mechanisms, however, 
common mechanisms have already been implemented. For example see
\code{\link{weighted_j2r}} 

A \code{print.ImputeMechanism} method is defined.
}
\section{Structure}{
 The following components must be included in
an ImputeMechanism Object
}

\examples{
j2r <- weighted_j2r(trt.weight=0)
}
