% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjusted_ratio_bin_seg.R
\name{adjusted_ratio_bin_seg}
\alias{adjusted_ratio_bin_seg}
\title{Adjusted Ratio Binary Segmentation}
\usage{
adjusted_ratio_bin_seg(input_data, minseglen, alpha)
}
\arguments{
\item{input_data}{A numeric matrix of observations for multivariate time series
data where the dimension is not greater than the observations. Date columns should not be inputted.}

\item{minseglen}{Minimum segment length for detecting change points.}

\item{alpha}{Level of significance for calculating the confidence intervals.}
}
\value{
A list with change points and segments.
}
\description{
Adjusted ratio binary segmentation.
}
\examples{
# Example usage
data <- matrix(rnorm(1000), ncol = 10)
result <- adjusted_ratio_bin_seg(data, minseglen = 30, alpha = 0.05)
}
