% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kww.R
\name{wwz2kww}
\alias{wwz2kww}
\title{Koopman-Wang-Wei from Wang-Wei-Zhu Decomposition}
\usage{
wwz2kww(x, aggregate = FALSE)
}
\arguments{
\item{x}{a data frame with the WWZ decomposition obtained from \code{\link{wwz}}. Alternatively a 'decompr' class object from \code{\link{load_tables_vectors}} can be supplied, which will toggle calling \code{wwz()} first.}

\item{aggregate}{logical. \code{TRUE} aggregates the KWW decomposition to the country level, giving exactly the same output as \code{\link{kww}}. \code{FALSE} maintains the sector level decomposition in KWW format.}
}
\value{
A data frame with exports decomposed into 9 components (columns), see the table above and \code{\link{kww}} for a shorter description of the 9 terms.
}
\description{
This function by default returns a disaggregated version of the the Koopman-Wang-Wei (KWW) decomposition breaking up sector-level gross exports into 9 value added terms,
from an already computed and more detailed (16 term) Wang-Wei-Zhu decomposition of sector-level gross exports. An aggregation option also allows obtaining the aggregate KWW decomposition.
}
\details{
The mapping of the 16 terms in the WWZ decomposition to the 9 terms in the KWW decomposition is provided in table E2 in the appendix of the WWZ (2013) paper. The table is reproduced here using the term naming 
conventions followed in this package.

\tabular{lllllll}{
 \emph{WWZ Terms} \tab\tab\tab \emph{KWW Term} \tab\tab\tab \emph{Description} \cr\cr\cr
 DVA_FIN \tab\tab\tab DVA_FIN \tab\tab\tab Domestic VA in final goods exports. \cr\cr\cr
 DVA_INT, DVA_INTrexI1 \tab\tab\tab DVA_INT \tab\tab\tab Domestic VA in intermediate exports absorbed by direct importers. 
 WWZ separates VA in final goods produced and consumed by direct importer from VA used by direct importer to produce intermediate exports for production of domestically consumed final goods 
 in third countries (i.e. the VA is absorbed by the direct importer, but it may be exported to third countries as intermediates first before returning to direct importer as final goods). \cr\cr\cr
 DVA_INTrexF, DVA_INTrexI2 \tab\tab\tab DVA_INTrex \tab\tab\tab Domestic VA in intermediate exports reexported to third countries and absorbed there. WWZ separates VA in final goods exports 
 of direct importer to third countries from VA in intermediate exports from direct importers to third countries (that is ultimately absorbed in third countries). \cr\cr\cr
 RDV_FIN, RDV_FIN2 \tab\tab\tab RDV_FIN \tab\tab\tab Domestic VA in intermediate exports that returns home via final imports. WWZ separates final imports from the direct importer and third countries. \cr\cr\cr
 RDV_INT \tab\tab\tab RDV_INT \tab\tab\tab Domestic VA in intermediate exports that returns via intermediate imports (i.e. is used to produce a locally consumed final good). \cr\cr\cr
 DDC_FIN, DDC_INT \tab\tab\tab DDC \tab\tab\tab Double counted Domestic Value Added in gross exports. WWZ separates double counting due to final and intermediate exports production. \cr\cr\cr
 MVA_FIN, OVA_FIN \tab\tab\tab FVA_FIN \tab\tab\tab Foreign VA in final goods exports. WWZ separates FVA from direct importer and from third countries.  \cr\cr\cr
 MVA_INT,  OVA_INT \tab\tab\tab FVA_INT \tab\tab\tab Foreign VA in intermediate exports. WWZ separates FVA from direct importer and from third countries. \cr\cr\cr
 MDC, ODC \tab\tab\tab FDC \tab\tab\tab Double counted Foreign Value Added in gross exports. WWZ separates FDC from direct importer and from third countries. \cr
 }
}
\note{
If both WWZ and KWW decompositions are required, it is computationally more efficient to call \code{wwz2kww(x, aggregate = TRUE)} on an already computed WWZ decomposition, than to call \code{\link{kww}} on a 'decompr' object.
}
\examples{

# Load example data
data(leather)

# Create intermediate object (class 'decompr')
decompr_object <- load_tables_vectors(leather)
 
# Perform the WWZ decomposition
WWZ <- wwz(decompr_object)

# Obtain a disaggregated KWW decomposition
KWW <- wwz2kww(WWZ)

# Aggregate KWW 
wwz2kww(WWZ, aggregate = TRUE)

# Same as running KWW directly, but the former is more efficient 
# if we already have the WWZ
kww(decompr_object)
}
\references{
Koopman, R., Wang, Z., & Wei, S. J. (2014). Tracing value-added and double counting in gross exports. \emph{American Economic Review, 104}(2), 459-94.

Wang, Zhi, Shang-Jin Wei, and Kunfu Zhu (2013). Quantifying international production sharing at the bilateral and sector levels (No. w19677). \emph{National Bureau of Economic Research}.
}
\seealso{
\code{\link{wwz}}, \code{\link{kww}}, \code{\link{decompr-package}}
}
\author{
Sebastian Krantz
}
