% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltip.R
\name{use_tooltip}
\alias{use_tooltip}
\title{Create a tooltip property}
\usage{
use_tooltip(html, style, ...)
}
\arguments{
\item{html}{The \code{innerHTML} of the element.}

\item{style}{A \code{cssText} string that will modefiy the default style of the element.}

\item{...}{not used}
}
\description{
Create a tooltip property
}
\section{Tooltip template Syntax}{

The tooltip string is a \emph{mustache} template in which variable names are identified
by the double curly brackets (\emph{mustache} tags) that surround them. The variable names available to the
template are given by deck.gl’s \code{pickingInfo.object} and vary by layer.
}

\examples{
data("bart_segments")

props <- list(
  tooltip = use_tooltip(
    html = "{{from_name}} to {{to_name}}",
    style = "background: steelBlue; border-radius: 5px;"
  )
)

# The picking object of the hexagon layer offers
# a property that contains the list of points of the hexagon.
# You can iterate over this list as shown below.
data("sf_bike_parking")

html = "
  <p>{{position.0}}, {{position.1}}<p>
  <p>Count: {{points.length}}</p>
  <p>{{#points}}<div>{{address}}</div>{{/points}}</p>
"
}
\seealso{
\href{https://github.com/janl/mustache.js}{mustache} for a complete syntax overwiew.
}
