% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_h3-hexagon-layer.R
\name{add_h3_hexagon_layer}
\alias{add_h3_hexagon_layer}
\title{Add a h3 hexagon layer to the deckgl widget}
\usage{
add_h3_hexagon_layer(deckgl, id = "h3-hexagon-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{deckgl widget}

\item{id}{id of the layer}

\item{data}{url to fetch data from or data object}

\item{properties}{named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class, additionally there is a \code{getTooltip} property (callback)
showing a tooltip when the mouse enters an object,
e. g. \code{getTooltip = JS("object => object.name")}}

\item{...}{more properties (will be added to the properties object), useful if you
want to use a properties object for more than one layer}
}
\description{
Add a h3 hexagon layer to the deckgl widget
}
\examples{
## @knitr h3-hexagon-layer-layer
h3_cells <- system.file("sample-data/h3-cells.csv", package = "deckgl") \%>\%
  read.csv()

properties <- list(
  getHexagon = ~h3_index,
  getFillColor =JS("d => [255, (1 - d.count / 500) * 255, 0]"),
  getElevation = ~count,
  elevationScale = 20,
  getTooltip = JS("object => `${object.h3_index}: ${object.count}`")
)

deck <- deckgl(zoom = 11, pitch = 35) \%>\%
  add_h3_hexagon_layer(data = h3_cells, properties = properties) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/h3-hexagon-layer}
}
