% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{plate_data}
\alias{plate_data}
\title{Plate data (droplets data)}
\usage{
plate_data(plate)
}
\arguments{
\item{plate}{A ddPCR plate}
}
\value{
A dataframe containing all the droplets in the plate, along with
the assigned cluster of each droplet.
}
\description{
The main piece of information in every ddPCR plate is the droplets data,
which contains the fluorescence intensities for every single droplet in
every well. After a ddPCR plate gets analyzed, this data also includes the
assigned cluster for each droplet. The plate data may be useful programatically,
but it's not very useful to a human, so if you want to visualize the plate data
you should instead plot it using \code{\link[ddpcr]{plot.ddpcr_plate}}.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir())
plate_data(plate)
} 
}
\seealso{
\code{\link[ddpcr]{plate_meta}}\cr
\code{\link[ddpcr]{plot.ddpcr_plate}}
}

